package com.example.demo.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;

import com.example.demo.entity.Campign;

public class CampignTempCustomRepoImpl implements CampignTempCustomRepo {
	
	@Autowired
	public EntityManager em;

	@Override
	public List<Campign> getallDetails(String name,List<String> auction_type, List<UUID> advertiser, List<String> categories,
			List<Integer> env_type, List<Integer> status, List<Integer> is_deleted, List<UUID> idList) {

		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<Campign> cq = cb.createQuery(Campign.class);
		Root<Campign> CampignTemp = cq.from(Campign.class);

		List<Predicate> predicates = new ArrayList<>();

		Predicate namepredicate = null;

		if (name == null) {

		} else if (name != null) {
			namepredicate = cb.like(CampignTemp.get("campign_name"), "%" + name + "%");
			predicates.add(namepredicate);
		}
		
		if(auction_type==null) {
			
		}
		else if(auction_type.size()>0) {
			List<Predicate> auctionPredicates = new ArrayList<>();
			for (String auction : auction_type) {
				auctionPredicates.add(cb.like(CampignTemp.get("auction_type"), "%" + auction + "%"));
			}
			Predicate categoryOrPredicate = cb.or(auctionPredicates.toArray(new Predicate[0]));
			predicates.add(categoryOrPredicate);
		}
		if (advertiser == null) {

		} else if (advertiser.size() > 0) {
			Expression<String> parentExpression = CampignTemp.get("advertiser_id");
			Predicate advertiserPredicate = parentExpression.in(advertiser);
			predicates.add(advertiserPredicate);
		}
		if (categories == null) {

		} else if (categories.size() > 0) {
			List<Predicate> categoryPredicates = new ArrayList<>();
			for (String category : categories) {
				categoryPredicates.add(cb.like(CampignTemp.get("categories"), "%" + category + "%"));
			}
			Predicate categoryOrPredicate = cb.or(categoryPredicates.toArray(new Predicate[0]));
			predicates.add(categoryOrPredicate);
		}
		if (env_type == null) {

		} else if (env_type.size() > 0) {
			Expression<String> parentExpression = CampignTemp.get("env_type");
			Predicate envPredicate = parentExpression.in(env_type);
			predicates.add(envPredicate);
		}
		Predicate statusPredicate = null;
		Predicate isdeletePredicate = null;
		Predicate statusAndDelete = null;
		Predicate statusAndDelete1 = null;
		if (status != null && is_deleted != null && status.size() > 0 && is_deleted.size() > 0) {

			if (status.size() > 0) {

				Expression<String> parentExpression = CampignTemp.get("status");
				statusPredicate = parentExpression.in(status);
				statusAndDelete = statusPredicate;

			}

			if (is_deleted.size() > 0) {

				Expression<String> parentExpression = CampignTemp.get("is_deleted");
				if (is_deleted.contains(1)) {
					isdeletePredicate = parentExpression.in(1);
				} else {
					isdeletePredicate = parentExpression.in(0);
				}
				statusAndDelete = isdeletePredicate;

			}
			if (status.size() > 0 && is_deleted.size() > 0) {
				statusAndDelete = cb.or(statusPredicate, isdeletePredicate);
			}

			if (!is_deleted.contains(1)) {// statusAndDelete
				statusAndDelete1 = cb.and(statusPredicate, isdeletePredicate);
				predicates.add(statusAndDelete1);
			} else {
				predicates.add(statusAndDelete);
			}

		} else {
			if (status == null) {

			} else if (status.size() > 0) {

				Expression<String> parentExpression = CampignTemp.get("status");
				statusPredicate = parentExpression.in(status);
				statusAndDelete = statusPredicate;
				predicates.add(statusAndDelete);
			}

			if (is_deleted == null) {

			} else if (is_deleted.size() > 0) {

				Expression<String> parentExpression = CampignTemp.get("is_deleted");
				isdeletePredicate = parentExpression.in(is_deleted);
				statusAndDelete = isdeletePredicate;
				predicates.add(statusAndDelete);
			}
		}
		if (idList == null) {

		} else if (idList.size() > 0) {
			Expression<String> parentExpression = CampignTemp.get("campign_id");
			Predicate idpredicate = parentExpression.in(idList);
			predicates.add(idpredicate);
		}
		cq.where(predicates.toArray(new Predicate[0]));
		TypedQuery<Campign> query = em.createQuery(cq);

		return query.getResultList();

	}

}
