package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.Campign;

public interface CampignRepository extends JpaRepository<Campign, UUID>, CampignTempCustomRepo {

	@Query(nativeQuery = true, value = "SELECT count(*) from app_campign where advertiser_id = :advertiser_id")
	int count(@Param("advertiser_id") UUID advertiser_id);

	@Query(nativeQuery = true, value = "SELECT COUNT(*) FROM app_campign WHERE campaign_id IN (:CampignId)")
	int getResultCount(@Param("CampignId") List<UUID> CampignIdList);

	@Query(nativeQuery = true, value = "SELECT * FROM app_campign where campaign_id IN (:campignid)")
	Page<Campign> getFilteredListwithoutPage(@Param("campignid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_campign where campaign_id IN (:campignid)")
	Page<Campign> getFilteredList(@Param("campignid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * from app_campign where advertiser_id IN (:advertiser_id)")
	List<Campign> findbyadvertiser_id(@Param("advertiser_id") UUID advertiser_id);

	@Query(nativeQuery = true, value = "SELECT * from app_campign where advertiser_id IN (:advertiser_id)")
	Page<Campign> findbyadvertiser(@Param("advertiser_id") UUID advertiser_id, Pageable pageable);

	@Query(nativeQuery = true, value ="SELECT * FROM app_campign LIMIT 10")
	List<Campign> findalladvertiser();
}
