package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.CampaignAdunit;

public interface CampaignAdunitRepo extends JpaRepository<CampaignAdunit, UUID> {

	@Query(nativeQuery = true, value = "SELECT * FROM app_campaign_adunit_assoc WHERE campaign_id = :campaignid AND adunit_id = :adunitid")
	CampaignAdunit findbyCampaignAndAdunit(@Param("campaignid") UUID campaign_id, @Param("adunitid") UUID adunit_id);

	@Query(nativeQuery = true, value = "SELECT * FROM app_campaign_adunit_assoc WHERE adunit_id = :adunitid")
	List<CampaignAdunit> findbyadunit(@Param("adunitid") UUID adunit_id);
}
