package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.Advertriser;

public interface AdvertriserRepo extends JpaRepository<Advertriser, UUID>, AdvertriserTempCustomRepo {

	@Query(nativeQuery = true, value = "SELECT * FROM app_advertiser WHERE email=:email")
	Advertriser findbyemail(String email);

	@Query(nativeQuery = true, value = "SELECT * FROM app_advertiser where advertiser_id IN (:advertiserid)")
	Page<Advertriser> getFilteredListwithoutPage(@Param("advertiserid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT COUNT(*) FROM app_advertiser WHERE advertiser_id  IN (:advertiserId)")
	int getResultCount(@Param("advertiserId") List<UUID> CreativeIdList);

	@Query(nativeQuery = true, value = "SELECT * FROM app_advertiser where advertiser_id  IN (:advertiserid)")
	Page<Advertriser> getFilteredList(@Param("advertiserid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_advertiser where advertiser_id  IN (:advertiser_id)")
	List<Advertriser> findbyadvertriser(@Param("advertiser_id") UUID advertiser_id);

	@Query(nativeQuery = true, value = "SELECT * FROM app_advertiser where advertiser_id  IN (:advertiser_id)")
	Page<Advertriser> findbyadvertriser_id(@Param("advertiser_id") UUID advertiser_id, Pageable pageable);

    @Query(nativeQuery = true,value="SELECT * FROM app_advertiser GROUP BY advertiser_id Limit 5")
	List<Advertriser> findbyadvertiser();
}
