package com.example.demo.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;

import com.example.demo.entity.ADFORMAT;
import com.example.demo.entity.Adunits;

public class AdunitsTempCustomRepoImpl implements AdunitsTempCustomRepo {

	@Autowired
	public EntityManager em;

	@Override
	public List<Adunits> getallDetails(String name, List<UUID> publisher, List<Integer> env_type,
			List<String> adunit_type, List<Integer> status, List<Integer> is_deleted, List<UUID> idList) {

		CriteriaBuilder cb = em.getCriteriaBuilder();
		CriteriaQuery<Adunits> cq = cb.createQuery(Adunits.class);
		Root<Adunits> adunittemp = cq.from(Adunits.class);

		List<Predicate> predicates = new ArrayList<>();

		Predicate namepredicate = null;

		if (name == null) {

		} else if (name != null) {
			namepredicate = cb.like(adunittemp.get("name"), "%" + name + "%");
			predicates.add(namepredicate);
		}
		if (publisher == null) {

		} else if (publisher.size() > 0) {
			Expression<String> parentExpression = adunittemp.get("publisher_id");
			Predicate publisherPredicate = parentExpression.in(publisher);
			predicates.add(publisherPredicate);
		}
		if (env_type == null) {

		} else if (env_type.size() > 0) {
			Expression<String> parentExpression = adunittemp.get("env_type");
			Predicate envPredicate = parentExpression.in(env_type);
			predicates.add(envPredicate);
		}

		if (adunit_type == null) {

		} else if (adunit_type.size() > 0) {

			List<ADFORMAT> adformats = new ArrayList<>();
			for (String str : adunit_type) {
				if (str.equalsIgnoreCase("Banner")) {
					ADFORMAT banner = ADFORMAT.Banner;
					adformats.add(banner);
				}
				if (str.equalsIgnoreCase("Video")) {
					ADFORMAT video = ADFORMAT.Video;
					adformats.add(video);
				}
			}
			Expression<String> parentExpression = adunittemp.get("adunit_type");
			Predicate adformatePredicate = parentExpression.in(adformats);
			predicates.add(adformatePredicate);
		}
		Predicate statusPredicate = null;
		Predicate isdeletePredicate = null;
		Predicate statusAndDelete = null;
		Predicate statusAndDelete1 = null;
		if (status != null && is_deleted != null && status.size() > 0 && is_deleted.size() > 0) {

			if (status.size() > 0) {

				Expression<String> parentExpression = adunittemp.get("status");
				statusPredicate = parentExpression.in(status);
				statusAndDelete = statusPredicate;

			}

			if (is_deleted.size() > 0) {

				Expression<String> parentExpression = adunittemp.get("is_deleted");
				if (is_deleted.contains(1)) {
					isdeletePredicate = parentExpression.in(1);
				} else {
					isdeletePredicate = parentExpression.in(0);
				}
				statusAndDelete = isdeletePredicate;

			}
			if (status.size() > 0 && is_deleted.size() > 0) {
				statusAndDelete = cb.or(statusPredicate, isdeletePredicate);
			}

			if (!is_deleted.contains(1)) {// statusAndDelete
				statusAndDelete1 = cb.and(statusPredicate, isdeletePredicate);
				predicates.add(statusAndDelete1);
			} else {
				predicates.add(statusAndDelete);
			}

		} else {
			if (status == null) {

			} else if (status.size() > 0) {

				Expression<String> parentExpression = adunittemp.get("status");
				statusPredicate = parentExpression.in(status);
				statusAndDelete = statusPredicate;
				predicates.add(statusAndDelete);
			}

			if (is_deleted == null) {

			} else if (is_deleted.size() > 0) {

				Expression<String> parentExpression = adunittemp.get("is_deleted");
				isdeletePredicate = parentExpression.in(is_deleted);
				statusAndDelete = isdeletePredicate;
				predicates.add(statusAndDelete);
			}
		}

		if (idList.size() >= 0) {
			Expression<String> parentExpression = adunittemp.get("adunit_id");
			Predicate idPredicate = parentExpression.in(idList);
			predicates.add(idPredicate);
		}
		cq.where(predicates.toArray(new Predicate[0]));
		TypedQuery<Adunits> query = em.createQuery(cq);

		return query.getResultList();

	}

}
