package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.Adunits;
import com.example.demo.entity.Publisher;

public interface AdunitRepository extends JpaRepository<Adunits, UUID>, AdunitsTempCustomRepo {

	@Query(nativeQuery = true, value = "SELECT * FROM app_adunits where adunit_id IN (:adunitid)")
	Page<Adunits> getFilteredListwithoutPage(@Param("adunitid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT COUNT(*) FROM app_adunits WHERE adunit_id IN (:adunitId)")
	int getResultCount(@Param("adunitId") List<UUID> CreativeIdList);

	@Query(nativeQuery = true, value = "SELECT * FROM app_adunits where adunit_id IN (:adunitid)")
	Page<Adunits> getFilteredList(@Param("adunitid") List<UUID> filteredId, Pageable pageable);

	@Query(nativeQuery = true, value = "SELECT * FROM app_adunits where publisher_id = :publisher_id")
	List<Adunits> findbypublisher_id(@Param("publisher_id") UUID publisher_id);

	@Query(nativeQuery = true, value = "SELECT * FROM app_adunits where publisher_id = :publisher_id")
	Page<Adunits> findbypublisher(@Param("publisher_id") UUID publisher_id, Pageable pageable);

	@Query(nativeQuery = true, value ="SELECT * FROM app_adunits  GROUP BY adunit_id LIMIT 5")
	List<Adunits> adunitidreport();
	
	@Query(nativeQuery = true, value = "SELECT * FROM app_adunits GROUP BY name LIMIT 5")
	List<Adunits> adunitnamereport();
	
	@Query(nativeQuery = true , value ="SELECT * FROM app_adunits GROUP BY status LIMIT 5")
	List<Adunits> adunitStatusreport();
	
	@Query(nativeQuery = true , value ="SELECT * FROM app_adunits GROUP BY adunit_type LIMIT 5")
	List<Adunits> adunittypereport();


}
