package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.AdunitEndpoint;

public interface AdunitEndpointRepository extends JpaRepository<AdunitEndpoint,UUID>{
	
	@Query(nativeQuery=true,value="SELECT * FROM app_adunit_endpoint Where adunit_id = :adunit_id")
	List<AdunitEndpoint> findbyadunit(@Param ("adunit_id") UUID adunit_id);
	
	@Query(nativeQuery=true,value="SELECT * FROM app_adunit_endpoint Where adunit_id = :adunit_id AND endpoint_id= :endpoint_id")
	AdunitEndpoint findbyadunitandEndpoint(@Param("adunit_id") UUID adunit_id,@Param ("endpoint_id") UUID endpoint_id);
	

}
