package com.example.demo.repository;

import java.util.List;
import java.util.UUID;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.AdunitBidder;

public interface AdunitBidderRepository extends JpaRepository<AdunitBidder,UUID>{

	@Query(nativeQuery=true,value="SELECT * FROM app_bidder_adunit_assoc WHERE adunit_id = :adunit_id")
	List<AdunitBidder> findbyadunitid(@Param ("adunit_id") UUID adunit_id);
	
	@Query(nativeQuery=true,value="SELECT * FROM app_bidder_adunit_assoc WHERE adunit_id = :adunit_id and bidder_id = :bidder_id")
	AdunitBidder findbyadunitandbidder(@Param ("adunit_id") UUID adunit_id,@Param ("bidder_id") UUID bidder_id);
}
