package com.example.demo.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import com.example.demo.entity.AdFormats;

public interface AdFormatRepo extends JpaRepository<AdFormats, Integer> {
	AdFormats findByType(String type);

	@Query(nativeQuery = true, value = "SELECT * FROM app_adformats where type like :type%")
	List<AdFormats> getAdformatByType(@Param("type") String type);

	@Query(nativeQuery = true, value = "SELECT * FROM app_adformats ORDER BY name")
	List<AdFormats> orderByName();
}