package com.example.demo.entity;

import java.util.Collection;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import io.swagger.v3.oas.annotations.media.Schema;

@Entity
@Table(name = "app_users")
public class User implements UserDetails {

	@Id
	@Column(name = "user_id", columnDefinition = "BINARY(16)")
	private UUID id;

	@Column(name = "user_name", columnDefinition = "VARCHAR(125)")
	private String name;

	@Column(name = "email", nullable = false, length = 50, unique = true, columnDefinition = "VARCHAR(225)")
	private String email;

	@Column(name = "pwd_hash", nullable = false, columnDefinition = "VARCHAR(125)")
	private String password;

	@Column(name = "role_id", columnDefinition = "BINARY(16)")
	private UUID roleid;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	@Schema(accessMode = Schema.AccessMode.READ_ONLY)
	private int isdeleted;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	@Schema(accessMode = Schema.AccessMode.READ_ONLY)
	private int status;

	public UUID getId() {
		return id;
	}

	public User() {
		super();
		// TODO Auto-generated constructor stub
	}

	public User(UUID id, String name, String email, String password, UUID roleid, int isdeleted, int status) {
		super();
		this.id = id;
		this.name = name;
		this.email = email;
		this.password = password;
		this.roleid = roleid;
		this.isdeleted = isdeleted;
		this.status = status;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public void setId(UUID id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public UUID getRoleid() {
		return roleid;
	}

	public void setRoleid(UUID roleid) {
		this.roleid = roleid;
	}

	public int getIsdeleted() {
		return isdeleted;
	}

	public void setIsdeleted(int isdeleted) {
		this.isdeleted = isdeleted;
	}

	@Override
	public Collection<? extends GrantedAuthority> getAuthorities() {
		return null;
	}

	@Override
	public String getUsername() {
		return this.email;
	}

	@Override
	public boolean isAccountNonExpired() {
		return true;
	}

	@Override
	public boolean isAccountNonLocked() {
		return true;
	}

	@Override
	public boolean isCredentialsNonExpired() {
		return true;
	}

	@Override
	public boolean isEnabled() {
		return true;
	}

}
