package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_sites")
public class Site {
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "site_id", columnDefinition = "BINARY(16)")
	private UUID site_id;

	@Column(name = "name", columnDefinition = "VARCHAR(125)")
	private String name;

	@Column(name = "site_url", columnDefinition = "VARCHAR(125)")
	private String site_url;

	@Column(name = "platform", columnDefinition = "CHAR(15)")
	private String platform;

	@Column(name = "categories", columnDefinition = "VARCHAR(1250)")
	private String category;

	@Column(name = "blocked_category", columnDefinition = "VARCHAR(1250)")
	private String blocked_category;

	@Column(name = "domain", columnDefinition = "VARCHAR(125)")
	private String domain;

	@Column(name = "appBundle_url", columnDefinition = "VARCHAR(125)")
	private String appBundle_url;

	@Column(name = "iTune_id", columnDefinition = "VARCHAR(125)")
	private String iTune_id;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	private int is_deleted;

	@Column(name = "deleted_at")
	private LocalDateTime deleted_at;

	@Column(name = "deleted_by", columnDefinition = "BINARY(16)")
	private UUID deleted_by;

	public UUID getSite_id() {
		return site_id;
	}

	public void setSite_id(UUID site_id) {
		this.site_id = site_id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSite_url() {
		return site_url;
	}

	public void setSite_url(String site_url) {
		this.site_url = site_url;
	}

	public String getPlatform() {
		return platform;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getAppBundle_url() {
		return appBundle_url;
	}

	public void setAppBundle_url(String appBundle_url) {
		this.appBundle_url = appBundle_url;
	}

	public String getiTune_id() {
		return iTune_id;
	}

	public void setiTune_id(String iTune_id) {
		this.iTune_id = iTune_id;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public String getBlocked_category() {
		return blocked_category;
	}

	public void setBlocked_category(String blocked_category) {
		this.blocked_category = blocked_category;
	}

	public String getDomain() {
		return domain;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}

}
