package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_setting")
public class Setting {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "setting_id", columnDefinition = "BINARY(16)")
	private UUID setting_id;

	@Column(name = "name", columnDefinition = "VARCHAR(255)")
	private String name;

	@Column(name = "domain", columnDefinition = "VARCHAR(255)")
	private String domain;

	@Column(name = "user_id", columnDefinition = "BINARY(16)")
	private UUID user_id;

	@Column(name = "account_currency", columnDefinition = "BINARY(16)")
	private UUID account_currency;

	@Column(name = "home_currency", columnDefinition = "BINARY(16)")
	private UUID home_currency;

	public UUID getSetting_id() {
		return setting_id;
	}

	public void setSetting_id(UUID setting_id) {
		this.setting_id = setting_id;
	}

	public UUID getUser_id() {
		return user_id;
	}

	public void setUser_id(UUID user_id) {
		this.user_id = user_id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDomain() {
		return domain;
	}

	public void setDomain(String domain) {
		this.domain = domain;
	}

	public UUID getAccount_currency() {
		return account_currency;
	}

	public void setAccount_currency(UUID account_currency) {
		this.account_currency = account_currency;
	}

	public UUID getHome_currency() {
		return home_currency;
	}

	public void setHome_currency(UUID home_currency) {
		this.home_currency = home_currency;
	}

}
