package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_roles")
public class Roles {

	@Id
	@GeneratedValue(generator = "uuid2", strategy = GenerationType.AUTO)
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "role_id", columnDefinition = "BINARY(16)")
	private UUID roleid;

	@Column(name = "role_name", columnDefinition = "VARCHAR(30)")
	private String rolename;

	@Column(name = "role_type", columnDefinition = "VARCHAR(30)")
	private String roletype;

	@Column(name = "access_level", columnDefinition = "TINYINT(1)")
	private int accessLevel;

	public UUID getRoleid() {
		return roleid;
	}

	public void setRoleid(UUID roleid) {
		this.roleid = roleid;
	}

	public String getRolename() {
		return rolename;
	}

	public void setRolename(String rolename) {
		this.rolename = rolename;
	}

	public String getRoletype() {
		return roletype;
	}

	public void setRoletype(String roletype) {
		this.roletype = roletype;
	}

	public int getAccessLevel() {
		return accessLevel;
	}

	public void setAccessLevel(int accessLevel) {
		this.accessLevel = accessLevel;
	}

	public Roles(UUID roleid, String rolename, String roletype, int accessLevel) {
		super();
		this.roleid = roleid;
		this.rolename = rolename;
		this.roletype = roletype;
		this.accessLevel = accessLevel;
	}

	public Roles() {
		super();
		// TODO Auto-generated constructor stub
	}

}
