package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="app_report")
public class Report {
    
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "report_id", columnDefinition = "BINARY(16)")
	private UUID report_id;
	
	@Column(name="name",columnDefinition="VARCHAR(125)")
	private String name;
	
	@Column(name="period",columnDefinition="VARCHAR(125)")
	private String period;
		
	@Column(name="start_date",columnDefinition="VARCHAR(125)")
	private String start_date;
	
	@Column(name="end_date",columnDefinition="VARCHAR(125)")
	private String end_date;
	
	@Column(name="group_by",columnDefinition="VARCHAR(1250)")
	private String group_by;
	
	@Column(name="filter",columnDefinition="VARCHAR(1250)")
	private String filter;
	
	@Column(name="timezone_id",columnDefinition="BINARY(16)")
	private UUID timezone_id;
	
	@Column(name="is_deleted",columnDefinition="TINYINT(1)")
	private int is_deleted;
	
	@Column(name="deleted_by",columnDefinition="BINARY(16)")
	private UUID deleted_by;
	
	@Column(name="deleted_at")
	private LocalDateTime deleted_at;

	public UUID getReport_id() {
		return report_id;
	}

	public void setReport_id(UUID report_id) {
		this.report_id = report_id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPeriod() {
		return period;
	}

	public void setPeriod(String period) {
		this.period = period;
	}

	public String getStart_date() {
		return start_date;
	}

	public void setStart_date(String start_date) {
		this.start_date = start_date;
	}

	public String getEnd_date() {
		return end_date;
	}

	public void setEnd_date(String end_date) {
		this.end_date = end_date;
	}

	public String getGroup_by() {
		return group_by;
	}

	public void setGroup_by(String group_by) {
		this.group_by = group_by;
	}

	public String getFilter() {
		return filter;
	}

	public void setFilter(String filter) {
		this.filter = filter;
	}

	public UUID getTimezone_id() {
		return timezone_id;
	}

	public void setTimezone_id(UUID timezone_id) {
		this.timezone_id = timezone_id;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}
	
	
}
