package com.example.demo.entity;

import java.time.LocalDate;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="app_payment")
public class Payment {
	
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "payment_id", columnDefinition = "BINARY(16)")
    private UUID payment_id;
	
	@Column(name="deposite_date")
	private LocalDate deposite_date;
	
	@Column(name="user_id",columnDefinition="BINARY(16)")
	private UUID user_id;
	
	@Column(name="advertiser_id",columnDefinition="BINARY(16)")
	private UUID advertiser_id;
	
	@Column(name = "deposite_amount", columnDefinition = "DECIMAL(8,2)")
	@NotNull
	private double amount;
	
	@Column(name="spend_amount",columnDefinition="DECIMAL(8,2)")
	private double spend_amount;
	
	@Column(name="payment_type",columnDefinition="VARCHAR(125)")
	private String payment_type;
	
	@Column(name="status",columnDefinition="TINYINT(1)")
	private int status;

	public UUID getPayment_id() {
		return payment_id;
	}

	public void setPayment_id(UUID payment_id) {
		this.payment_id = payment_id;
	}

	public LocalDate getDeposite_date() {
		return deposite_date;
	}

	public void setDeposite_date(LocalDate deposite_date) {
		this.deposite_date = deposite_date;
	}

	public UUID getUser_id() {
		return user_id;
	}

	public void setUser_id(UUID user_id) {
		this.user_id = user_id;
	}

	public double getAmount() {
		return amount;
	}

	public void setAmount(double amount) {
		this.amount = amount;
	}

	public String getPayment_type() {
		return payment_type;
	}

	public void setPayment_type(String payment_type) {
		this.payment_type = payment_type;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public double getSpend_amount() {
		return spend_amount;
	}

	public void setSpend_amount(double spend_amount) {
		this.spend_amount = spend_amount;
	}

	public UUID getAdvertiser_id() {
		return advertiser_id;
	}

	public void setAdvertiser_id(UUID advertiser_id) {
		this.advertiser_id = advertiser_id;
	}
	
	

}
