package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;

import io.swagger.v3.oas.annotations.media.Schema;

@Entity
@Table(name = "app_users")
public class ManageUser {

	@Id
	@Column(name = "user_id", columnDefinition = "BINARY(16)")
	private UUID id;

	@Column(name = "user_name", columnDefinition = "VARCHAR(125)")
	private String name;

	@NotEmpty(message = "{email.notempty}")
	@Email(regexp = "[a-zA-Z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,3}")
	@Column(name = "email", columnDefinition = "VARCHAR(225)")
	private String email;

	@Column(name = "pwd_hash", nullable = false, columnDefinition = "VARCHAR(125)")
	private String password;

	@Column(name = "role_id", columnDefinition = "BINARY(16)")
	private UUID roleid;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	@Schema(accessMode = Schema.AccessMode.READ_ONLY)
	private int status;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	private int is_deleted;

	@Column(name = "deleted_at")
	private LocalDateTime deleted_at;

	@Column(name = "deleted_by", columnDefinition = "BINARY(16)")
	private UUID deleted_by;

	public UUID getId() {
		return id;
	}

	public void setId(UUID id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public UUID getRoleid() {
		return roleid;
	}

	public void setRoleid(UUID roleid) {
		this.roleid = roleid;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public ManageUser(UUID id, @NotEmpty(message = "{firstname.notempty}") String name,
			@NotEmpty(message = "{email.notempty}") @Email(regexp = "[a-zA-Z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,3}") String email,
			String password, UUID roleid, int status, LocalDateTime created_at, UUID created_by,
			LocalDateTime updated_at, UUID updated_by, int is_deleted, LocalDateTime deleted_at, UUID deleted_by) {
		super();
		this.id = id;
		this.name = name;
		this.email = email;
		this.password = password;
		this.roleid = roleid;
		this.status = status;
		this.created_at = created_at;
		this.created_by = created_by;
		this.updated_at = updated_at;
		this.updated_by = updated_by;
		this.is_deleted = is_deleted;
		this.deleted_at = deleted_at;
		this.deleted_by = deleted_by;
	}

	public ManageUser() {
		super();
		// TODO Auto-generated constructor stub
	}

}
