package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="app_endpoint")
public class EndPoint {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "endpoint_id", columnDefinition = "BINARY(16)")
	private UUID endpoint_id;
	
	@Column(name="demand_partner",columnDefinition="BINARY(16)")
	private UUID demand_partner;
	
	@Column(name="endpoint_name",columnDefinition="VARCHAR(125)")
	private String endpoint_name;
		
	@Column(name="bid_floor",columnDefinition="DECIMAL(8,4)")
	private double bid_floor;
		
	@Column(name="seller_id",columnDefinition="VARCHAR(125)")
	private String seller_id;
	
	@Column(name="adtype",columnDefinition="INT")
	private int adtype;
	
	@Column(name="dsp_params",columnDefinition="VARCHAR(1250)")
	private String dsp_params;
	
	@Column(name="created_at")
	private LocalDateTime created_at;
	
	@Column(name="created_by",columnDefinition="BINARY(16)")
	private UUID created_by;
	
	@Column(name="updated_at")
	private LocalDateTime updated_at;
	
	@Column(name="updated_by",columnDefinition="BINARY(16)")
	private UUID updated_by;
	
	@Column(name="is_deleted",columnDefinition="TINYINT(1)")
	private int is_deleted;
	
	@Column(name="deleted_at")
	private LocalDateTime deleted_at;
	
	@Column(name="deleted_by",columnDefinition="BINARY(16)")
	private UUID deleted_by;

	public UUID getEndpoint_id() {
		return endpoint_id;
	}

	public void setEndpoint_id(UUID endpoint_id) {
		this.endpoint_id = endpoint_id;
	}

	public UUID getDemand_partner() {
		return demand_partner;
	}

	public void setDemand_partner(UUID demand_partner) {
		this.demand_partner = demand_partner;
	}

	public String getEndpoint_name() {
		return endpoint_name;
	}

	public void setEndpoint_name(String endpoint_name) {
		this.endpoint_name = endpoint_name;
	}

	public double getBid_floor() {
		return bid_floor;
	}

	public void setBid_floor(double bid_floor) {
		this.bid_floor = bid_floor;
	}

	public String getSeller_id() {
		return seller_id;
	}

	public void setSeller_id(String seller_id) {
		this.seller_id = seller_id;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public int getAdtype() {
		return adtype;
	}

	public void setAdtype(int adtype) {
		this.adtype = adtype;
	}

	public String getDsp_params() {
		return dsp_params;
	}

	public void setDsp_params(String dsp_params) {
		this.dsp_params = dsp_params;
	}

}
