package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_dsp")
public class Dsp {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "adexchange_id", columnDefinition = "BINARY(16)")
	private UUID adexchange_id;

	@Column(name = "adexchange_name", columnDefinition = "VARCHAR(125)")
	private String AdExchange_name;

	@Column(name = "email", columnDefinition = "VARCHAR(125)")
	private String email;

	@Column(name = "version", columnDefinition = "VARCHAR(1250)")
	private String version;

	@Column(name = "bid_auction_type", columnDefinition = "VARCHAR(125)")
	private String bid_auction_type;

	@Column(name = "rtb_mode", columnDefinition = "TINYINT(1)")
	private int rtb_mode;
	
	@Column(name="params",columnDefinition="VARCHAR(1250)")
	private String params;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	private int status;
	
	@Column(name="is_deleted",columnDefinition="TINYINT(1)")
	private int is_deleted;
	
	@Column(name="deleted_at")
	private LocalDateTime deleted_at;
	
	@Column(name="deleted_by",columnDefinition="BINARY(16)")
	private UUID deleted_by;

	public UUID getAdexchange_id() {
		return adexchange_id;
	}

	public void setAdexchange_id(UUID adexchange_id) {
		this.adexchange_id = adexchange_id;
	}

	public String getAdExchange_name() {
		return AdExchange_name;
	}

	public void setAdExchange_name(String adExchange_name) {
		AdExchange_name = adExchange_name;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getBid_auction_type() {
		return bid_auction_type;
	}

	public void setBid_auction_type(String bid_auction_type) {
		this.bid_auction_type = bid_auction_type;
	}

	public int getRtb_mode() {
		return rtb_mode;
	}

	public void setRtb_mode(int rtb_mode) {
		this.rtb_mode = rtb_mode;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public String getParams() {
		return params;
	}

	public void setParams(String params) {
		this.params = params;
	}

}
