package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="app_deal")
public class Deal {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name="deal_id",columnDefinition="BINARY(16)")
	private UUID deal_id;
	
	@Column(name="name",columnDefinition="VARCHAR(125)")
	private String name;
	
	@Column(name="bidfloor",columnDefinition="VARCHAR(125)")
	private String bidfloor;
	
	@Column(name="including_seats",columnDefinition="VARCHAR(125)")
    private String including_seats;
    
	@Column(name="keywords",columnDefinition="VARCHAR(125)")
    private String Keywords;
    
	@Column(name="created_at")
	private LocalDateTime created_at;
	
	@Column(name="created_by",columnDefinition="BINARY(16)")
	private UUID created_by;
	
	@Column(name="updated_at")
	private LocalDateTime updated_at;
	
	@Column(name="updated_by",columnDefinition="BINARY(16)")
	private UUID updated_by;
	
	@Column(name="is_deleted",columnDefinition="TINYINT(1)")
	private int is_deleted;
	
	@Column(name="deleted_by",columnDefinition="BINARY(16)")
	private UUID deleted_by;
	
	@Column(name="deleted_at")
	private LocalDateTime deleted_at;

	public UUID getDeal_id() {
		return deal_id;
	}

	public void setDeal_id(UUID deal_id) {
		this.deal_id = deal_id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getBidfloor() {
		return bidfloor;
	}

	public void setBidfloor(String bidfloor) {
		this.bidfloor = bidfloor;
	}

	public String getIncluding_seats() {
		return including_seats;
	}

	public void setIncluding_seats(String including_seats) {
		this.including_seats = including_seats;
	}

	public String getKeywords() {
		return Keywords;
	}

	public void setKeywords(String keywords) {
		Keywords = keywords;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}
	
	
	
}
