package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_currency")
public class Currency {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "currency_id", columnDefinition = "BINARY(16)")
	private UUID currency_id;

	@Column(name = "code", columnDefinition = "CHAR(3)")
	private String code;

	@Column(name = "name", columnDefinition = "VARCHAR(35)")
	private String name;

	@Column(name = "symbol", columnDefinition = "CHAR(5)")
	private String symbol;

	@Column(name = "html_code", columnDefinition = "VARCHAR(15)")
	private String html_code;

	public UUID getCurrency_id() {
		return currency_id;
	}

	public void setCurrency_id(UUID currency_id) {
		this.currency_id = currency_id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSymbol() {
		return symbol;
	}

	public void setSymbol(String symbol) {
		this.symbol = symbol;
	}

	public String getHtml_code() {
		return html_code;
	}

	public void setHtml_code(String html_code) {
		this.html_code = html_code;
	}

}
