package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_creative")
public class Creative {
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "creative_id", columnDefinition = "BINARY(16)")
	private UUID creative_id;

	@Column(name = "name", columnDefinition = "VARCHAR(255)")
	private String name;

	@Column(name = "ad_format", columnDefinition = "enum('Banner','Video')")
	@Enumerated(EnumType.STRING)
	private ADFORMAT adformat;

	@Column(name = "ad_type", columnDefinition = "enum('B_IMG','B_HTML','B_TAG','V_LINEAR','V_VAST')")
	@Enumerated(EnumType.STRING)
	private ADTYPE adtype;

	@Column(name = "filename", columnDefinition = "VARCHAR(255)")
	private String filename;

	@Column(name = "destination", columnDefinition = "VARCHAR(255)")
	private String destination;

	@Column(name = "campign_id", columnDefinition = "BINARY(16)")
	private UUID campign_id;

	@Column(name = "banner_size", columnDefinition = "BINARY(16)")
	private UUID banner_size;

	@Column(name = "frequency_capping", columnDefinition = "VARCHAR(125)")
	private String frequency_capping;

	@Column(name = "impression_capping", columnDefinition = "VARCHAR(125)")
	private String impression_capping;

	@Column(name = "thirdparty_tag", columnDefinition = "VARCHAR(255)")
	private String thirdparty_tag;

	@Column(name = "src_obj", columnDefinition = "VARCHAR(1250)")
	private String src_obj;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	private int is_deleted;

	@Column(name = "deleted_by", columnDefinition = "BINARY(16)")
	private UUID deleted_by;

	@Column(name = "deleted_at")
	private LocalDateTime deleted_at;

	public UUID getCreative_id() {
		return creative_id;
	}

	public void setCreative_id(UUID creative_id) {
		this.creative_id = creative_id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public ADFORMAT getAdformat() {
		return adformat;
	}

	public void setAdformat(ADFORMAT adformat) {
		this.adformat = adformat;
	}

	public ADTYPE getAdtype() {
		return adtype;
	}

	public void setAdtype(ADTYPE adtype) {
		this.adtype = adtype;
	}

	public String getFilename() {
		return filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}

	public String getDestination() {
		return destination;
	}

	public void setDestination(String destination) {
		this.destination = destination;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getCampign_id() {
		return campign_id;
	}

	public void setCampign_id(UUID campign_id) {
		this.campign_id = campign_id;
	}

	public UUID getBanner_size() {
		return banner_size;
	}

	public void setBanner_size(UUID banner_size) {
		this.banner_size = banner_size;
	}

	public String getSrc_obj() {
		return src_obj;
	}

	public void setSrc_obj(String src_obj) {
		this.src_obj = src_obj;
	}

	public String getFrequency_capping() {
		return frequency_capping;
	}

	public void setFrequency_capping(String frequency_capping) {
		this.frequency_capping = frequency_capping;
	}

	public String getImpression_capping() {
		return impression_capping;
	}

	public void setImpression_capping(String impression_capping) {
		this.impression_capping = impression_capping;
	}

	public String getThirdparty_tag() {
		return thirdparty_tag;
	}

	public void setThirdparty_tag(String thirdparty_tag) {
		this.thirdparty_tag = thirdparty_tag;
	}

	public Creative(UUID creative_id, String name, ADFORMAT adformat, ADTYPE adtype, String filename,
			String destination, UUID campign_id, UUID banner_size, String frequency_capping, String impression_capping,
			String thirdparty_tag, String src_obj, UUID created_by, LocalDateTime created_at, UUID updated_by,
			LocalDateTime updated_at, int is_deleted, UUID deleted_by, LocalDateTime deleted_at) {
		super();
		this.creative_id = creative_id;
		this.name = name;
		this.adformat = adformat;
		this.adtype = adtype;
		this.filename = filename;
		this.destination = destination;
		this.campign_id = campign_id;
		this.banner_size = banner_size;
		this.frequency_capping = frequency_capping;
		this.impression_capping = impression_capping;
		this.thirdparty_tag = thirdparty_tag;
		this.src_obj = src_obj;
		this.created_by = created_by;
		this.created_at = created_at;
		this.updated_by = updated_by;
		this.updated_at = updated_at;
		this.is_deleted = is_deleted;
		this.deleted_by = deleted_by;
		this.deleted_at = deleted_at;
	}

	public Creative() {
		super();
		// TODO Auto-generated constructor stub
	}

}
