package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_configurations")
public class Configurations {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "config_id", columnDefinition = "BINARY(16)")
	private UUID configId;

	@Column(name = "config_key", columnDefinition = "VARCHAR(255)")
	private String configKey;

	@Column(name = "config_value", columnDefinition = "VARCHAR(255)")
	private String configValue;

	@Column(name = "title", columnDefinition = "VARCHAR(255)")
	private String title;

	@Column(name = "type", columnDefinition = "VARCHAR(255)")
	private String type;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	private int status;

	@Column(name = "options", columnDefinition = "VARCHAR(255)")
	private String options;

	@Column(name = "field_type", columnDefinition = "enum('TEXT','SELECT','RANGE')")
	@Enumerated(EnumType.STRING)
	private FIELDTYPE field_type;

	public Configurations(String configKey, String configValue, String title, String type, int status, String options,
			FIELDTYPE field_type) {
		super();
		this.configKey = configKey;
		this.configValue = configValue;
		this.title = title;
		this.type = type;
		this.status = status;
		this.options = options;
		this.field_type = field_type;
	}

	public Configurations() {
		super();
	}

	public UUID getConfigId() {
		return configId;
	}

	public void setConfigId(UUID configId) {
		this.configId = configId;
	}

	public String getConfigKey() {
		return configKey;
	}

	public void setConfigKey(String configKey) {
		this.configKey = configKey;
	}

	public String getConfigValue() {
		return configValue;
	}

	public void setConfigValue(String configValue) {
		this.configValue = configValue;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getOptions() {
		return options;
	}

	public void setOptions(String options) {
		this.options = options;
	}

	public FIELDTYPE getField_type() {
		return field_type;
	}

	public void setField_type(FIELDTYPE field_type) {
		this.field_type = field_type;
	}

}
