package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="app_conf_timezone")
public class ConfTimeZone {
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "zone_id", columnDefinition = "BINARY(16)")
	private UUID zoneId;

	@Column(name = "name", columnDefinition = "VARCHAR(125)")
	private String name;

	@Column(name = "code", columnDefinition = "CHAR(6)")
	private String code;

	@Column(name = "offset", columnDefinition = "CHAR(15)")
	private String offset;

	public UUID getZoneId() {
		return zoneId;
	}

	public void setZoneId(UUID zoneId) {
		this.zoneId = zoneId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getOffset() {
		return offset;
	}

	public void setOffset(String offset) {
		this.offset = offset;
	}
	
	

}
