package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_campign")
public class Campign {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "campaign_id", columnDefinition = "BINARY(16)")
	private UUID campign_id;

	@Column(name = "advertiser_id", columnDefinition = "BINARY(16)")
	private UUID advertiser_id;

	@Column(name = "name", columnDefinition = "VARCHAR(225)")
	private String campign_name;

	@Column(name = "env_type", columnDefinition = "TINYINT(1)")
	private int env_type;

	@Column(name = "bid_price", columnDefinition = "Decimal(8,4)")
	private double bid_price;

	@Column(name = "duration", columnDefinition = "VARCHAR(1250)")
	private String duration;
	
	@Column(name="dayparting",columnDefinition="VARCHAR(1250)")
	private String dayparting;
	
	@Column(name = "ssp", columnDefinition = "VARCHAR(1250)")
	private String ssp;

	@Column(name="auction_type",columnDefinition="VARCHAR(1250)")
	private String auction_type;

	@Column(name = "categories", columnDefinition = "VARCHAR(1250)")
	private String categories;

	@Column(name = "pricing_model", columnDefinition = "CHAR(15)")
	private String pricing_model;

	@Column(name = "deal", columnDefinition = "VARCHAR(1250)")
	private String deal;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	private int status;

	@Column(name = "total_budget", columnDefinition = "DECIMAL(8,4)")
	private double campaignBudget;

	@Column(name = "daily_budget", columnDefinition = "DECIMAL(8,4)")
	private double dailyBudget;

	@Column(name = "total_impression")
	private int total_impression;

	@Column(name = "daily_impression")
	private int daily_impression;

	@Column(name = "impression_capping", columnDefinition = "VARCHAR(125)")
	private String impression_capping;

	@Column(name = "pacing", columnDefinition = "VARCHAR(125)")
	private String pacing;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	private int is_deleted;

	@Column(name = "deleted_at")
	private LocalDateTime deleted_at;

	@Column(name = "deleted_by", columnDefinition = "BINARY(16)")
	private UUID deleted_by;

	public String getCampign_name() {
		return campign_name;
	}

	public void setCampign_name(String campign_name) {
		this.campign_name = campign_name;
	}

	public UUID getCampign_id() {
		return campign_id;
	}

	public void setCampign_id(UUID campign_id) {
		this.campign_id = campign_id;
	}

	public int getEnv_type() {
		return env_type;
	}

	public UUID getAdvertiser_id() {
		return advertiser_id;
	}

	public void setAdvertiser_id(UUID advertiser_id) {
		this.advertiser_id = advertiser_id;
	}

	public void setEnv_type(int env_type) {
		this.env_type = env_type;
	}

	public double getBid_price() {
		return bid_price;
	}

	public void setBid_price(double bid_price) {
		this.bid_price = bid_price;
	}

	public String getDuration() {
		return duration;
	}

	public void setDuration(String duration) {
		this.duration = duration;
	}

	public String getPricing_model() {
		return pricing_model;
	}

	public void setPricing_model(String pricing_model) {
		this.pricing_model = pricing_model;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public double getCampaignBudget() {
		return campaignBudget;
	}

	public void setCampaignBudget(double campaignBudget) {
		this.campaignBudget = campaignBudget;
	}

	public double getDailyBudget() {
		return dailyBudget;
	}

	public void setDailyBudget(double dailyBudget) {
		this.dailyBudget = dailyBudget;
	}

	public String getCategories() {
		return categories;
	}

	public void setCategories(String categories) {
		this.categories = categories;
	}

	public int getTotal_impression() {
		return total_impression;
	}

	public void setTotal_impression(int total_impression) {
		this.total_impression = total_impression;
	}

	public int getDaily_impression() {
		return daily_impression;
	}

	public void setDaily_impression(int daily_impression) {
		this.daily_impression = daily_impression;
	}

	public String getImpression_capping() {
		return impression_capping;
	}

	public void setImpression_capping(String impression_capping) {
		this.impression_capping = impression_capping;
	}

	public String getPacing() {
		return pacing;
	}

	public void setPacing(String pacing) {
		this.pacing = pacing;
	}

	public String getDeal() {
		return deal;
	}

	public void setDeal(String deal) {
		this.deal = deal;
	}

	public String getAuction_type() {
		return auction_type;
	}

	public void setAuction_type(String auction_type) {
		this.auction_type = auction_type;
	}

	public String getSsp() {
		return ssp;
	}

	public void setSsp(String ssp) {
		this.ssp = ssp;
	}

	public String getDayparting() {
		return dayparting;
	}

	public void setDayparting(String dayparting) {
		this.dayparting = dayparting;
	}

	
}
