package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;



@Entity
@Table(name = "app_bidder")
public class Bidder {
	
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "bidder_id", columnDefinition = "BINARY(16)")
	private UUID bidder_id;

	@Column(name = "bidder_name", columnDefinition = "VARCHAR(125)")
	private String bidder_name;

	@Column(name = "bidder_code", columnDefinition = "VARCHAR(125)")
	private String bidder_code;

	@Column(name = "bidder_parameters", columnDefinition = "VARCHAR(1250)")
	private String bidder_parameters;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	private int is_deleted;

	@Column(name = "deleted_at")
	private LocalDateTime deleted_at;

	@Column(name = "deleted_by", columnDefinition = "BINARY(16)")
	private UUID deleted_by;

	public UUID getBidder_id() {
		return bidder_id;
	}

	public void setBidder_id(UUID bidder_id) {
		this.bidder_id = bidder_id;
	}

	public String getBidder_name() {
		return bidder_name;
	}

	public void setBidder_name(String bidder_name) {
		this.bidder_name = bidder_name;
	}

	public String getBidder_code() {
		return bidder_code;
	}

	public void setBidder_code(String bidder_code) {
		this.bidder_code = bidder_code;
	}

	public String getBidder_parameters() {
		return bidder_parameters;
	}

	public void setBidder_parameters(String bidder_parameters) {
		this.bidder_parameters = bidder_parameters;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

}
