package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import io.swagger.annotations.ApiModelProperty;

@Entity
@Table(name = "app_banner")
public class BannerSize {
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "size_id", columnDefinition = "BINARY(16)")
	@ApiModelProperty(hidden = true)
	private UUID size_id;

	@Column(name = "size_name", columnDefinition = "VARCHAR(55)")
	private String size_name;

	@Column(name = "height")
	private int height;

	@Column(name = "width")
	private int width;

	public BannerSize() {
		super();
	}

	public UUID getSize_id() {
		return size_id;
	}

	public void setSize_id(UUID size_id) {
		this.size_id = size_id;
	}

	public String getSize_name() {
		return size_name;
	}

	public void setSize_name(String size_name) {
		this.size_name = size_name;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public BannerSize(UUID size_id, String size_name, int height, int width) {
		super();
		this.size_id = size_id;
		this.size_name = size_name;
		this.height = height;
		this.width = width;
	}

}
