package com.example.demo.entity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_advertiser")
public class Advertriser {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "advertiser_id", columnDefinition = "BINARY(16)")
	private UUID advertiser_id;

	@Column(name = "advertiser_name", columnDefinition = "VARCHAR(125)")
	private String advertiser_name;

	@Column(name = "email", nullable = false, length = 50, unique = true, columnDefinition = "VARCHAR(225)")
	private String email;

	@Column(name = "total_balance", columnDefinition = "DECIMAL(8,2)")
	@NotNull
	private double total_balance;

	@Column(name = "total_spend", columnDefinition = "DECIMAL(8,2)")
	@NotNull
	private double total_spend;

	@Column(name = "deposite_amount", columnDefinition = "DECIMAL(8,2)")
	@NotNull
	private double deposite_amount;

	@Column(name = "deposite_date")
	private LocalDate deposite_date;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	private int is_deleted;

	@Column(name = "deleted_at")
	private LocalDateTime deleted_at;

	@Column(name = "deleted_by", columnDefinition = "BINARY(16)")
	private UUID deleted_by;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	private int status;

	public void setAdvertiser_id(UUID advertiser_id) {
		this.advertiser_id = advertiser_id;
	}

	public String getAdvertiser_name() {
		return advertiser_name;
	}

	public void setAdvertiser_name(String advertiser_name) {
		this.advertiser_name = advertiser_name;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public UUID getAdvertiser_id() {
		return advertiser_id;
	}

	public void setAdvertriser_id(UUID advertiser_id) {
		this.advertiser_id = advertiser_id;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public double getTotal_balance() {
		return total_balance;
	}

	public void setTotal_balance(double total_balance) {
		this.total_balance = total_balance;
	}

	public double getTotal_spend() {
		return total_spend;
	}

	public void setTotal_spend(double total_spend) {
		this.total_spend = total_spend;
	}

	public double getDeposite_amount() {
		return deposite_amount;
	}

	public void setDeposite_amount(double deposite_amount) {
		this.deposite_amount = deposite_amount;
	}

	public LocalDate getDeposite_date() {
		return deposite_date;
	}

	public void setDeposite_date(LocalDate deposite_date) {
		this.deposite_date = deposite_date;
	}

}
