package com.example.demo.entity;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_adunits")
public class Adunits {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "adunit_id", columnDefinition = "BINARY(16)")
	private UUID adunit_id;

	@Column(name = "name", columnDefinition = "VARCHAR(125)")
	private String name;

	@Column(name = "publisher_id", columnDefinition = "BINARY(16)")
	private UUID publisher_id;

	@Column(name = "site_id", columnDefinition = "BINARY(16)")
	private UUID site_id;

	@Column(name = "banner_size", columnDefinition = "BINARY(16)")
	private UUID banner_size;

	@Column(name = "adunit_type", columnDefinition = "enum('Banner','Video')")
	@Enumerated(EnumType.STRING)
	private ADFORMAT adunit_type;

	@Column(name = "env_type", columnDefinition = "TINYINT(1)")
	private int env_type;

	@Column(name = "floor_price", columnDefinition = "VARCHAR(125)")
	private String floor_price;
	
	@Column(name="auction_type",columnDefinition="VARCHAR(1250)")
	private String auction_type;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	private int status;

	@Column(name = "created_at")
	private LocalDateTime created_at;

	@Column(name = "created_by", columnDefinition = "BINARY(16)")
	private UUID created_by;

	@Column(name = "updated_at")
	private LocalDateTime updated_at;

	@Column(name = "updated_by", columnDefinition = "BINARY(16)")
	private UUID updated_by;

	@Column(name = "is_deleted", columnDefinition = "TINYINT(1)")
	private int is_deleted;

	@Column(name = "deleted_at")
	private LocalDateTime deleted_at;

	@Column(name = "deleted_by", columnDefinition = "BINARY(16)")
	private UUID deleted_by;

	public UUID getAdunit_id() {
		return adunit_id;
	}

	public void setAdunit_id(UUID adunit_id) {
		this.adunit_id = adunit_id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public UUID getPublisher_id() {
		return publisher_id;
	}

	public void setPublisher_id(UUID publisher_id) {
		this.publisher_id = publisher_id;
	}

	public ADFORMAT getAdunit_type() {
		return adunit_type;
	}

	public UUID getBanner_size() {
		return banner_size;
	}

	public void setBanner_size(UUID banner_size) {
		this.banner_size = banner_size;
	}

	public void setAdunit_type(ADFORMAT adunit_type) {
		this.adunit_type = adunit_type;
	}

	public int getEnv_type() {
		return env_type;
	}

	public void setEnv_type(int env_type) {
		this.env_type = env_type;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public LocalDateTime getCreated_at() {
		return created_at;
	}

	public void setCreated_at(LocalDateTime created_at) {
		this.created_at = created_at;
	}

	public UUID getCreated_by() {
		return created_by;
	}

	public void setCreated_by(UUID created_by) {
		this.created_by = created_by;
	}

	public LocalDateTime getUpdated_at() {
		return updated_at;
	}

	public void setUpdated_at(LocalDateTime updated_at) {
		this.updated_at = updated_at;
	}

	public UUID getUpdated_by() {
		return updated_by;
	}

	public void setUpdated_by(UUID updated_by) {
		this.updated_by = updated_by;
	}

	public int getIs_deleted() {
		return is_deleted;
	}

	public void setIs_deleted(int is_deleted) {
		this.is_deleted = is_deleted;
	}

	public LocalDateTime getDeleted_at() {
		return deleted_at;
	}

	public void setDeleted_at(LocalDateTime deleted_at) {
		this.deleted_at = deleted_at;
	}

	public UUID getDeleted_by() {
		return deleted_by;
	}

	public void setDeleted_by(UUID deleted_by) {
		this.deleted_by = deleted_by;
	}

	public String getFloor_price() {
		return floor_price;
	}

	public void setFloor_price(String floor_price) {
		this.floor_price = floor_price;
	}

	public UUID getSite_id() {
		return site_id;
	}

	public void setSite_id(UUID site_id) {
		this.site_id = site_id;
	}

	public String getAuction_type() {
		return auction_type;
	}

	public void setAuction_type(String auction_type) {
		this.auction_type = auction_type;
	}

}
