package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="app_adunit_endpoint")
public class AdunitEndpoint {
	
	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "assoc_id", columnDefinition = "BINARY(16)")
	private UUID assoc_id;
	
	@Column(name="adunit_id",columnDefinition="BINARY(16)")
	private UUID adunit_id;
	
	@Column(name="endpoint_id",columnDefinition="BINARY(16)")
	private UUID endpoint_id;

	public UUID getAssoc_id() {
		return assoc_id;
	}

	public void setAssoc_id(UUID assoc_id) {
		this.assoc_id = assoc_id;
	}

	public UUID getAdunit_id() {
		return adunit_id;
	}

	public void setAdunit_id(UUID adunit_id) {
		this.adunit_id = adunit_id;
	}

	public UUID getEndpoint_id() {
		return endpoint_id;
	}

	public void setEndpoint_id(UUID endpoint_id) {
		this.endpoint_id = endpoint_id;
	}
	
}
