package com.example.demo.entity;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;

import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "app_access_request")
public class AccessRequest {

	@Id
	@GeneratedValue(generator = "uuid2")
	@GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(name = "request_id", columnDefinition = "BINARY(16)")
	private UUID request_id;

	@Column(name = "name", columnDefinition = "VARCHAR(255)")
	private String name;

	@Column(name = "pwd_hash", columnDefinition = "VARCHAR(255)")
	private String pwd_hash;

	@Column(name = "website", columnDefinition = "VARCHAR(255)")
	private String website;

	@NotEmpty(message = "{email.notempty}")
	@Email(regexp = "[a-zA-Z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,3}")
	@Column(name = "email", columnDefinition = "VARCHAR(225)")
	private String email;

	@Column(name = "role_type", columnDefinition = "BINARY(16)")
	private UUID role_type;

	@Column(name = "postcurrency", columnDefinition = "VARCHAR(255)")
	private String postcurrrency;

	@Column(name = "status", columnDefinition = "TINYINT(1)")
	private int status;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public UUID getRequest_id() {
		return request_id;
	}

	public void setRequest_id(UUID request_id) {
		this.request_id = request_id;
	}

	public String getPwd_hash() {
		return pwd_hash;
	}

	public void setPwd_hash(String pwd_hash) {
		this.pwd_hash = pwd_hash;
	}

	public String getWebsite() {
		return website;
	}

	public void setWebsite(String website) {
		this.website = website;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public UUID getRole_type() {
		return role_type;
	}

	public void setRole_type(UUID role_type) {
		this.role_type = role_type;
	}

	public String getPostcurrrency() {
		return postcurrrency;
	}

	public void setPostcurrrency(String postcurrrency) {
		this.postcurrrency = postcurrrency;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public AccessRequest(UUID request_id, String name, String pwd_hash, String website,
			@NotEmpty(message = "{email.notempty}") @Email(regexp = "[a-zA-Z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,3}") String email,
			UUID role_type, String postcurrrency, int status) {
		super();
		this.request_id = request_id;
		this.name = name;
		this.pwd_hash = pwd_hash;
		this.website = website;
		this.email = email;
		this.role_type = role_type;
		this.postcurrrency = postcurrrency;
		this.status = status;
	}

	public AccessRequest() {
		super();
		// TODO Auto-generated constructor stub
	}

}
