package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.SspCreateDTO;
import com.example.demo.dto.SspDeleteDTO;
import com.example.demo.dto.SspUpdateDTO;
import com.example.demo.service.SspService;

@RestController
@RequestMapping("api/ssp")
public class SspController {
	
	@Autowired
	private SspService service;
	
	@PostMapping("create")
	private APIResponse createssp(@RequestBody SspCreateDTO create) {
		APIResponse api = service.createssp(create);
		return api;
	}
	
	@PutMapping("update/{adexchange_id}")
	private APIResponse updatessp(@RequestBody SspUpdateDTO update,@PathVariable ("adexchange_id") UUID adexchange_id) {
		APIResponse api = service.updatessp(update, adexchange_id);
		return api;
	}
	

	@GetMapping("list/{adexchange_id}")
	private APIResponse getbyid(@PathVariable ("adexchange_id") UUID adexchange_id) {
		APIResponse api = service.getbyid(adexchange_id);
		return api;
	}
	
	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}
	
	@PostMapping("delete")
	private APIResponse deletessp(@RequestBody SspDeleteDTO delete) {
		APIResponse api = service.deletessp(delete);
		return api;
	}
}
