package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.SiteCreateDTO;
import com.example.demo.dto.SiteDeleteDTO;
import com.example.demo.dto.SiteFilterEntity;
import com.example.demo.dto.SiteUpdateDTO;
import com.example.demo.service.SiteService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("api/site")
public class SiteController {

	@Autowired
	private SiteService service;

	@PostMapping("create")
	private APIResponse createsite(@RequestBody SiteCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.createSite(create);
		return api;
	}

	@PutMapping("update/{site_id}")
	private APIResponse updatesite(@RequestBody SiteUpdateDTO update, @PathVariable("site_id") UUID site_id)
			throws JsonProcessingException {
		APIResponse api = service.updateSite(update, site_id);
		return api;
	}

	@PostMapping("delete")
	private APIResponse deletesite(@RequestBody SiteDeleteDTO delete) {
		APIResponse api = service.deleteSite(delete);
		return api;
	}

	@GetMapping("getbyid/{site_id}")
	private APIResponse getbyid(@PathVariable("site_id") UUID site_id) {
		APIResponse api = service.getbyid(site_id);
		return api;
	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@PostMapping("filter")
	private FilterResponse filter(@RequestBody SiteFilterEntity filter) {
		FilterResponse fil = service.list(filter);
		return fil;
	}
}
