package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.SettingsCreateDTO;
import com.example.demo.service.SettingsService;

@RestController
@RequestMapping("api/setting")
public class SettingsController {

	@Autowired
	private SettingsService service;

	@PutMapping("create/{user_id}")
	private APIResponse createsettings(@RequestBody SettingsCreateDTO create, @PathVariable("user_id") UUID user_id) {
		APIResponse api = service.createsettings(create, user_id);
		return api;
	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@GetMapping("getbyid/{user_id}")
	private APIResponse getbyId(@PathVariable("user_id") UUID user_id) {
		APIResponse api = service.getbyId(user_id);
		return api;
	}
}
