package com.example.demo.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.repository.RolesRepository;
import com.example.demo.service.RoleService;

@CrossOrigin
@RestController
@RequestMapping("/api/role")
public class RolesController {
	@Autowired
	RoleService service;

	@Autowired
	RolesRepository repo;

	@GetMapping("list/{access_level}")
	public APIResponse getAll(@PathVariable(name = "access_level") int accessLevel) {

		APIResponse api = new APIResponse();
		api.setData(service.getRoles(accessLevel));
		api.setMessage("List of Roles By Level");
		api.setMsgCode("LIST_OF_ROLES_BY_LEVEL");
		return api;
	}

}
