package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.ReportCreateDTO;
import com.example.demo.dto.ReportDeleteDTO;
import com.example.demo.service.ReportService;
import com.example.demo.service.ReportingService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("api/report")
public class ReportingController {

	@Autowired
	private ReportingService service;
	
	@Autowired
	private ReportService reportservice;
	
	
	@GetMapping("generate")
	private APIResponse generatereport(){
		APIResponse api = service.generatereport();
		return api;
	}
	
	@PostMapping("create")
	private APIResponse Createreport(@RequestBody ReportCreateDTO create) throws JsonProcessingException {
		APIResponse api = reportservice.create(create);
		return api;
	}
	
	@GetMapping("list/{report_id}")
	private APIResponse getbyid(@PathVariable("report_id") UUID report_id) {
		APIResponse api = reportservice.getbyid(report_id);
		return api;
	}
	
	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = reportservice.list();
		return api;
	}
	
	@PostMapping("delete")
	private APIResponse deletereport(@RequestBody ReportDeleteDTO deleted) {
		APIResponse api = reportservice.deletereport(deleted);
		return api;
	}
}
