package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.PublisherDeleteDTO;
import com.example.demo.dto.PublisherFilterRequest;
import com.example.demo.dto.PublisherLoginCreateDTO;
import com.example.demo.dto.PublisherUpdateDTO;
import com.example.demo.service.PublisherService;

@RestController
@CrossOrigin
@RequestMapping("/api/publisher")
public class PublisherController {

	@Autowired
	private PublisherService service;

	@PostMapping("create")
	private APIResponse create(@RequestBody PublisherLoginCreateDTO create) {
		APIResponse api = service.create(create);
		return api;
	}

	@PutMapping("update/{publisher_id}")
	private APIResponse update(@RequestBody PublisherUpdateDTO update,
			@PathVariable("publisher_id") UUID publisher_id) {
		APIResponse api = service.update(update, publisher_id);
		return api;
	}

	@PostMapping("block/{publisher_id}")
	private APIResponse blockPublisher(@PathVariable("publisher_id") UUID publisher_id) {
		APIResponse api = service.block(publisher_id);
		return api;
	}

	@PostMapping("Unblock/{publisher_id}")
	private APIResponse UnblockPublisher(@PathVariable("publisher_id") UUID publisher_id) {
		APIResponse api = service.unblock(publisher_id);
		return api;
	}

	@PostMapping("delete")
	private APIResponse delete(@RequestBody PublisherDeleteDTO delete) {
		APIResponse api = service.delete(delete);
		return api;
	}

	@GetMapping("getbyid/{publisher_id}")
	private APIResponse getbyid(@PathVariable(name = "publisher_id") UUID publisher_id) {
		APIResponse api = service.getbyid(publisher_id);
		return api;
	}

	@PostMapping("list")
	private FilterResponse getall(@RequestBody PublisherFilterRequest filter, @RequestHeader UUID user_id) {
		FilterResponse api = service.getall(filter, user_id);
		return api;
	}
}
