package com.example.demo.controller;

import java.sql.SQLException;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.AddFundDTO;
import com.example.demo.dto.PaymentCreateDTO;
import com.example.demo.dto.PaymentFilterRequest;
import com.example.demo.service.PaymentService;

@RestController
@RequestMapping("api/payment")
public class PaymentController {

	@Autowired
	private PaymentService service;
	

	@PostMapping("fund/{user_id}")
	private APIResponse addfund(@RequestBody AddFundDTO fund, @PathVariable("user_id") UUID user_id) {
		APIResponse api = service.addfund(fund, user_id);
		return api;
	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@GetMapping("getbyid/{payment_id}")
	private APIResponse getbyId(@PathVariable("payment_id") UUID payment_id) {
		APIResponse api = service.getbyid(payment_id);
		return api;
	}
	
	@PostMapping("approve/{payment_id}")
	private APIResponse approvepayment(@PathVariable("payment_id") UUID payment_id) {
		APIResponse api = service.ApprovePayment(payment_id);
		return api;
	}
	
	@PostMapping("reject/{payment_id}")
	private APIResponse rejectpayment(@PathVariable("payment_id") UUID payment_id) {
		APIResponse api = service.RejectPayment(payment_id);
		return api;
	}
	
	@PostMapping("addfund/{advertiser_id}")
	private APIResponse createpayment(@RequestBody PaymentCreateDTO create,@PathVariable("advertiser_id") UUID advertiser_id) {
		APIResponse api = service.createpayment(create, advertiser_id);
		return api;
	}
	
	@PostMapping("list/{user_id}")
	private FilterResponse filter(@RequestBody PaymentFilterRequest filter,@PathVariable("user_id") UUID user_id) {
		FilterResponse fill = service.filterrequest(filter, user_id);
		return fill;
	}
	
	@GetMapping("history")
	private APIResponse history(){
		APIResponse api = service.paymenthistroy();
		return api;
	}
}
