package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.service.ManageUserService;

@RestController
@RequestMapping("/api/Manageuser")
public class ManageUserController {

	@Autowired
	private ManageUserService service;

	@GetMapping("getbyid/{user_id}")
	private APIResponse getbyid(@PathVariable(name = "user_id") UUID user_id) {
		APIResponse api = service.getbtid(user_id);
		return api;
	}

	@GetMapping("getall")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

//	@PutMapping("update/{user_id}")
//	private APIResponse update(@RequestBody ManageUserUpdateDTO update,@PathVariable(name="user_id")UUID user_id) {
//		APIResponse api = service.updateUser(update, user_id);
//		return api;
//	}
}
