package com.example.demo.controller;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.example.demo.entity.FileUploadModel;
import com.example.demo.entity.FileUploadResponse;
import com.example.demo.service.FileUploadItf;

@Validated
@RestController
@RequestMapping("/api/fileupload")
public class FileUploadController {

	@Autowired
	FileUploadItf fileUploadItf;

	FileUploadModel upfile = new FileUploadModel();

	@RequestMapping(method = RequestMethod.POST, value = "upload")
	public ResponseEntity<FileUploadResponse> uploadMultipleFiles(@RequestParam("files") MultipartFile[] files,
			@RequestParam("adtype") String adtype, @RequestParam(name = "sizeof", required = false) UUID sizeof,
			@RequestParam("cusheight") String cusheight, @RequestParam("cuswidth") String cuswidth,
			@RequestParam("custome") String custome) {

		FileUploadResponse responsess = new FileUploadResponse();
		responsess.setStatuscode(HttpStatus.OK.toString());

		List<FileUploadModel> responces = Arrays.asList(files).stream().map(file -> {
			upfile = null;
			try {
				upfile = fileUploadItf.saveFile(file, adtype, sizeof, cusheight, cuswidth, custome);
			} catch (IOException e) {
				e.printStackTrace();
			}

			if (file.getOriginalFilename().contains(".zip")) {

				try {
					Files.deleteIfExists(upfile.getFileExistPathCheck());
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			return new FileUploadModel(upfile.getFilePath(), upfile.getMessage(), upfile.getFileExistPathCheck());
		}).collect(Collectors.toList());

		responsess.setData(responces);
		return ResponseEntity.status(HttpStatus.OK).body(responsess);
	}
}
