package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.EndPointUpdateDTO;
import com.example.demo.dto.EndpointCreateDTO;
import com.example.demo.dto.EndpointDeleteDTO;
import com.example.demo.service.EndPointService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("/api/endpoint")
public class EndPointController {
    
	@Autowired
	private EndPointService service;
	
	@PostMapping("create")
	private APIResponse createendpoint(@RequestBody EndpointCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.createEndpoint(create);
		return api;
	}
	
	@PutMapping("update/{endpoint_id}")
	private APIResponse updateendpoint(@RequestBody EndPointUpdateDTO update,@PathVariable("endpoint_id") UUID endpoint_id) throws JsonProcessingException {
		APIResponse api = service.updateEndpoint(update, endpoint_id);
		return api;
	}
	
	@GetMapping("list/{endpoint_id}")
	private APIResponse getbyid(@PathVariable("endpoint_id") UUID endpoint_id) {
		APIResponse api = service.getbyid(endpoint_id);
		return api;
	}
	
	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}
	
	@PostMapping("delete")
	private APIResponse deleteendpoint(@RequestBody EndpointDeleteDTO delete) {
		APIResponse api = service.deletedEndpoint(delete);
		return api;
	}
}
