package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.DspCreateDTO;
import com.example.demo.dto.DspDeleteDTO;
import com.example.demo.dto.DspFilterRequest;
import com.example.demo.dto.DspUpdateDTO;
import com.example.demo.service.DspService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("api/dsp")
public class DspController {

	@Autowired
	private DspService service;

	@PostMapping("create")
	private APIResponse createdsp(@RequestBody DspCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.createdsp(create);
		return api;
	}

	@PutMapping("update/{adexchange_id}")
	private APIResponse updatedsp(@RequestBody DspUpdateDTO update, @PathVariable("adexchange_id") UUID adexchange_id) throws JsonProcessingException {
		APIResponse api = service.updatedsp(update, adexchange_id);
		return api;
	}

	@GetMapping("list/{adexchange_id}")
	private APIResponse getbyId(@PathVariable("adexchange_id") UUID adexchange_id) {
		APIResponse api = service.getbyId(adexchange_id);
		return api;
	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@PostMapping("block/{adexchange_id}")
	private APIResponse blockdsp(@PathVariable("adexchange_id") UUID adexchange_id) {
		APIResponse api = service.blockdsp(adexchange_id);
		return api;
	}

	@PostMapping("unblock/{adexchange_id}")
	private APIResponse unblockdsp(@PathVariable("adexchange_id") UUID adexchange_id) {
		APIResponse api = service.unblockdsp(adexchange_id);
		return api;
	}
	
	@PostMapping("delete")
	private APIResponse deletedsp(@RequestBody DspDeleteDTO delete) {
		APIResponse api = service.deletedsp(delete);
		return api;
	}

	@PostMapping("filter")
	private FilterResponse list(DspFilterRequest filter) {
		FilterResponse api = service.list(filter);
		return api;
	}
}
