package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.DealCreateDTO;
import com.example.demo.dto.DealDeleteDTO;
import com.example.demo.dto.DealUpdateDTO;
import com.example.demo.service.DealService;

@RestController
@RequestMapping("api/deal")
public class DealController {

	@Autowired
	private DealService service;

	@PostMapping("create")
	private APIResponse createdeal(@RequestBody DealCreateDTO create) {
		APIResponse api = service.createdeal(create);
		return api;
	}

	@PutMapping("update/{deal_id}")
	private APIResponse updatedeal(@RequestBody DealUpdateDTO update, @PathVariable("deal_id") UUID deal_id) {
		APIResponse api = service.updatedeal(update, deal_id);
		return api;
	}

	@GetMapping("list/{deal_id}")
	private APIResponse getbyId(@PathVariable("deal_id") UUID deal_id) {
		APIResponse api = service.getbyId(deal_id);
		return api;
	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@PostMapping("delete")
	private APIResponse deletedeal(@RequestBody DealDeleteDTO delete) {
		APIResponse api = service.deletedeal(delete);
		return api;
	}
}
