package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.CreativeCreateDTO;
import com.example.demo.dto.CreativeDeleteDTO;
import com.example.demo.dto.CreativeFilterRequest;
import com.example.demo.dto.CreativeUpdateDTO;
import com.example.demo.service.CreativeService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("/api/creative")
public class CreativeController {

	@Autowired
	private CreativeService service;

	@PostMapping("create")
	private APIResponse create(@RequestBody CreativeCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.createcreative(create);
		return api;
	}

	@PutMapping("update/{creative_id}")
	private APIResponse update(@RequestBody CreativeUpdateDTO update, @PathVariable("creative_id") UUID creative_id)
			throws JsonProcessingException {
		APIResponse api = service.Updatecreative(update, creative_id);
		return api;
	}

	@PostMapping("delete")
	private APIResponse delete(@RequestBody CreativeDeleteDTO delete) {
		APIResponse api = service.deletecreative(delete);
		return api;
	}

	@GetMapping("getbyid/{creative_id}")
	private APIResponse getbyid(@PathVariable(name = "creative_id") UUID creative_id) {
		APIResponse api = service.getbyid(creative_id);
		return api;
	}

	@GetMapping("/getall")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@PostMapping("list")
	private FilterResponse list(@RequestBody CreativeFilterRequest filter, @RequestHeader UUID user_id) {
		FilterResponse api = service.list(filter, user_id);
		return api;
	}
}
