package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.CampignCreateDTO;
import com.example.demo.dto.CampignDeleteDTO;
import com.example.demo.dto.CampignFilterRequest;
import com.example.demo.dto.CampignUpdateDTO;
import com.example.demo.service.CampignService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("/api/campaign")
public class CampignController {

	@Autowired
	private CampignService service;

	@PostMapping("create")
	private APIResponse create(@RequestBody CampignCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.createcampign(create);
		return api;
	}

	@PutMapping("update/{campaign_id}")
	private APIResponse update(@RequestBody CampignUpdateDTO update, @PathVariable("campaign_id") UUID campaign_id)
			throws JsonProcessingException {
		APIResponse api = service.Updatecampign(update, campaign_id);
		return api;
	}

	@PostMapping("block/{campaign_id}")
	private APIResponse block(@PathVariable("campaign_id") UUID campaign_id) {
		APIResponse api = service.blockCampign(campaign_id);
		return api;
	}

	@PostMapping("unblock/{campaign_id}")
	private APIResponse Unblock(@PathVariable("campaign_id") UUID campaign_id) {
		APIResponse api = service.UnblockCampign(campaign_id);
		return api;
	}

	@PostMapping("delete")
	private APIResponse delete(@RequestBody CampignDeleteDTO delete) {
		APIResponse api = service.deleteCampign(delete);
		return api;
	}

	@GetMapping("getbyid/{campaign_id}")
	private APIResponse getbyid(@PathVariable(name = "campaign_id") UUID campaign_id) {
		APIResponse api = service.getbyid(campaign_id);
		return api;
	}

	@GetMapping("getall")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@PostMapping("list")
	private FilterResponse list(@RequestBody CampignFilterRequest filter) {
		FilterResponse fill = service.list(filter);
		return fill;
	}
}
