package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.CampaignTargetCreateDTO;
import com.example.demo.service.CampaignTargetService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("api/campaigntarget")
public class CampaignTargetController {

	@Autowired
	private CampaignTargetService service;

	@PostMapping("create")
	private APIResponse savetarget(@RequestBody CampaignTargetCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.savetarget(create);
		return api;

	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@GetMapping("list/{campaign_id}")
	private APIResponse getbyId(@PathVariable("campaign_id") UUID campaign_id) {
		APIResponse api = service.listbyId(campaign_id);
		return api;
	}
}
