package com.example.demo.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.CampaignAdunitLinkDTO;
import com.example.demo.dto.CampaignAdunitListDTO;
import com.example.demo.service.CampaignAdunitService;

@RestController
@RequestMapping("api/campaignAdunit")
public class CampaignAdunitController {

	@Autowired
	private CampaignAdunitService service;

	@PostMapping("link")
	private APIResponse link(@RequestBody CampaignAdunitLinkDTO link) {
		APIResponse api = service.createlink(link);
		return api;
	}

	@PostMapping("unlink")
	private APIResponse unlink(@RequestBody CampaignAdunitLinkDTO unlink) {
		APIResponse api = service.deletelink(unlink);
		return api;
	}

	@PostMapping("list")
	private APIResponse campaignlist(@RequestBody CampaignAdunitListDTO list) {
		APIResponse api = service.list(list);
		return api;
	}
}
