package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.dto.BidderCreateDTO;
import com.example.demo.dto.BidderDeleteDTO;
import com.example.demo.dto.BidderUpdateDTO;
import com.example.demo.service.BidderService;
import com.fasterxml.jackson.core.JsonProcessingException;

@RestController
@RequestMapping("/api/bidder")
public class BidderController {

	@Autowired
	private BidderService service;

	@PostMapping("create")
	private APIResponse createbidder(@RequestBody BidderCreateDTO create) throws JsonProcessingException {
		APIResponse api = service.createbidder(create);
		return api;
	}

	@PutMapping("update/{bidder_id}")
	private APIResponse updatebidder(@RequestBody BidderUpdateDTO update, @PathVariable("bidder_id") UUID bidder_id)
			throws JsonProcessingException {
		APIResponse api = service.updatebidder(update, bidder_id);
		return api;
	}

	@GetMapping("list/{bidder_id}")
	private APIResponse getbyId(@PathVariable("bidder_id") UUID bidder_id) {
		APIResponse api = service.getbyId(bidder_id);
		return api;
	}

	@GetMapping("list")
	private APIResponse getall() {
		APIResponse api = service.getall();
		return api;
	}

	@PostMapping("delete")
	private APIResponse deletebidder(@RequestBody BidderDeleteDTO delete) {
		APIResponse api = service.deletebidder(delete);
		return api;
	}
}
