package com.example.demo.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.service.BannerSizeService;

@RestController
@RequestMapping("/api/bannersize")
public class BannerSizeController {
	@Autowired
	private BannerSizeService service;

	@GetMapping("list")
	public ResponseEntity<APIResponse> getAll() {
		APIResponse response = service.getAllBannerSize();
		return ResponseEntity.status(response.getStatuscode()).body(response);
	}
}
