package com.example.demo.controller;

import java.util.UUID;

import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.AuthRequest;
import com.example.demo.common.AuthResponse;
import com.example.demo.common.ErrorObj;
import com.example.demo.entity.Roles;
import com.example.demo.entity.User;
import com.example.demo.exception.ResourceNotFoundException;
import com.example.demo.repository.RolesRepository;
import com.example.demo.repository.UserRepository;
import com.example.demo.util.JwtTokenUtil;

@CrossOrigin
@RestController
public class AuthApi {
	@Autowired
	AuthenticationManager authManager;

	@Autowired
	JwtTokenUtil jwtUtil;

	@Autowired
	private UserRepository userRepo;

	@Autowired
	private RolesRepository rolerepo;

	@GetMapping("/welcome")
	public String welcome() {
		return "Welcome to admaru check new build!!";
	}

	@PostMapping("/auth/login")
	public ResponseEntity<?> login(@RequestBody @Valid AuthRequest request) {
		try {
			Authentication authentication = authManager
					.authenticate(new UsernamePasswordAuthenticationToken(request.getEmail(), request.getPassword()));
			String type = null;
			String accountType = null;
			APIResponse api = new APIResponse();
			User user = (User) authentication.getPrincipal();
			String accessToken = jwtUtil.generateAccessToken(user);
			User userTable = null;
			User use = userRepo.findByEmail(request.getEmail())
					.orElseThrow(() -> new ResourceNotFoundException("Authentication", "is", request.getEmail()));
			UUID uid = use.getRoleid();
			Roles rtbl = rolerepo.findByRoleid(uid);
			accountType = rtbl.getRoletype();

			if (user.getStatus() == 0) {
				api.setMsgCode("INACTIVE_USER");
				ErrorObj error = new ErrorObj();
				error.setCode("INACTIVE_USER");
				api.setError(error);
				return ResponseEntity.ok().body(api);
			}
			if (user.getIsdeleted() == 1) {
				api.setMsgCode("DELECTED_USER");
				ErrorObj error = new ErrorObj();
				error.setCode("DELECTED_USER");
				api.setError(error);
				return ResponseEntity.ok().body(api);
			}

			AuthResponse response = new AuthResponse(user.getId(), user.getEmail(), accessToken, accountType);
			api.setData(response);
			api.setMsgCode("TOKEN GENERATED");
			api.setMessage("Token Generated successfully");
			return ResponseEntity.ok().body(api);

		} catch (BadCredentialsException ex) {
			return ResponseEntity.status(HttpStatus.UNAUTHORIZED).build();
		}
	}
}
