package com.example.demo.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.example.demo.common.APIResponse;
import com.example.demo.common.FilterResponse;
import com.example.demo.dto.AdvertiserDeleteDTO;
import com.example.demo.dto.AdvertriserCreateDTO;
import com.example.demo.dto.AdvertriserFilterRequest;
import com.example.demo.dto.AdvertriserUpdateDTO;
import com.example.demo.service.AdvertriserService;

@RestController
@RequestMapping("/api/advertriser")
public class AdvertriserController {

	@Autowired
	private AdvertriserService service;

	@PostMapping("create")
	private APIResponse create(@RequestBody AdvertriserCreateDTO dto) {
		APIResponse api = service.CreateAdvertriser(dto);
		return api;
	}

	@PutMapping("update/{advertiser_id}")
	private APIResponse update(@RequestBody AdvertriserUpdateDTO dto,
			@PathVariable("advertiser_id") UUID advertiser_id) {
		APIResponse api = service.UpdateAdvertriser(dto, advertiser_id);
		return api;
	}

	@PostMapping("list")
	private FilterResponse list(@RequestBody AdvertriserFilterRequest fill, @RequestHeader UUID user_id) {
		FilterResponse filter = service.list(fill, user_id);
		return filter;
	}

	@PostMapping("block/{advertiser_id}")
	private APIResponse blockadvertiser(@PathVariable("advertiser_id") UUID advertiser_id) {
		APIResponse api = service.blockAdvertiser(advertiser_id);
		return api;
	}

	@PostMapping("Unblock/{advertiser_id}")
	private APIResponse Unblockadvertiser(@PathVariable("advertiser_id") UUID advertiser_id) {
		APIResponse api = service.UnblockAdvertiser(advertiser_id);
		return api;
	}

	@PostMapping("delete")
	private APIResponse deleteadvertiser(@RequestBody AdvertiserDeleteDTO dto) {
		APIResponse api = service.deleteAdvertiser(dto);
		return api;

	}

	@GetMapping("getbyid/{advertiser_id}")
	private APIResponse getbyId(@PathVariable(name = "advertiser_id") UUID advertiser_id) {
		APIResponse api = service.getbyid(advertiser_id);
		return api;
	}

}
